import argparse

def get_isometry_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--epochs", type=int,default=2000, help='number of epochs')
    parser.add_argument("--lr", type=float,default=0.0001, help='learning rate')
    parser.add_argument("--shuffle",type=bool,default=True,help="shuffle true or false")
    parser.add_argument("--train_size",type=float,default=0.8,help="train size")
    parser.add_argument("--n_steps",type=int,default=10,help="number of steps")
    parser.add_argument("--seed",type=int,default=0,help="seed")
    parser.add_argument("--n_layers",type=int,default=5,help="number of layers")
    parser.add_argument("--alpha1",type=float,default=5.0,help="global loss weight")
    parser.add_argument("--alpha2",type=float,default=5.0,help="graph matching loss weight")
    parser.add_argument("--alpha3",type=float,default=1.0,help="low dimensional loss weight")
    parser.add_argument("--alpha4",type=float,default=0.001,help="jacobian loss weight")
    parser.add_argument("--n_dim",type=int,default=1,help="number of dimensions")
    parser.add_argument("--hidden_nf",type=int,default=64,help="hidden units")
    parser.add_argument("--n_neighbors",type=int,default=5,help="number of neighbors")
    parser.add_argument("--batch_size",type=int,default=64,help="batch size")
    parser.add_argument("--warmup",type=int,default=50,help="warmup")
    parser.add_argument("--split",type=bool,default=True,help="split true or false")
    args = parser.parse_args()
    return args

def get_VAE_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--epochs", type=int,default=2000, help='number of epochs')
    parser.add_argument("--lr", type=float,default=0.0001, help='learning rate')
    parser.add_argument("--shuffle",type=bool,default=True,help="shuffle true or false")
    parser.add_argument("--train_size",type=float,default=0.8,help="train size")
    parser.add_argument("--seed",type=int,default=0,help="seed")
    parser.add_argument("--n_layers",type=int,default=5,help="number of layers")
    parser.add_argument("--beta",type=float,default=1.0,help="beta")
    parser.add_argument("--n_dim",type=int,default=1,help="number of dimensions")
    parser.add_argument("--hidden_nf",type=int,default=64,help="hidden units")
    parser.add_argument("--n_neighbors",type=int,default=5,help="number of neighbors")
    parser.add_argument("--batch_size",type=int,default=64,help="batch size")
    parser.add_argument("--split",type=bool,default=True,help="split true or false")
    args = parser.parse_args()
    return args

def get_CFM_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--epochs", type=int,default=5000, help='number of epochs')
    parser.add_argument("--lr", type=float,default=0.0005, help='learning rate')
    parser.add_argument("--shuffle",type=bool,default=True,help="shuffle true or false")
    parser.add_argument("--train_size",type=float,default=0.8,help="train size")
    parser.add_argument("--seed",type=int,default=0,help="seed")
    parser.add_argument("--n_layers",type=int,default=10,help="number of layers")
    parser.add_argument("--hidden_nf",type=int,default=64,help="hidden units")
    parser.add_argument("--split",type=bool,default=True,help="split true or false")
    parser.add_argument("--batch_size",type=int,default=64,help="batch size")
    args = parser.parse_args()
    return args


def get_PFM_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--epochs", type=int,default=5000, help='number of epochs')
    parser.add_argument("--lr", type=float,default=0.0005, help='learning rate')
    parser.add_argument("--shuffle",type=bool,default=True,help="shuffle true or false")
    parser.add_argument("--train_size",type=float,default=0.8,help="train size")
    parser.add_argument("--seed",type=int,default=0,help="seed")
    parser.add_argument("--varphi_n_steps",type=int,default=10,help="number of steps")
    parser.add_argument("--varphi_n_layers",type=int,default=5,help="number of layers")
    parser.add_argument("--varphi_hidden_nf",type=int,default=64,help="hidden units")
    parser.add_argument("--n_layers",type=int,default=10,help="number of layers")
    parser.add_argument("--hidden_nf",type=int,default=64,help="hidden units")
    parser.add_argument("--split",type=bool,default=True,help="split true or false")
    parser.add_argument("--batch_size",type=int,default=64,help="batch size")
    parser.add_argument("--path",type=str,default="models/interpolation/run-20240728_130602-cxjuyx7v/files/parameters",help="path to CNF model")
    args = parser.parse_args()
    return args

def get_d_PFM_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--epochs", type=int,default=5000, help='number of epochs')
    parser.add_argument("--lr", type=float,default=0.0005, help='learning rate')
    parser.add_argument("--shuffle",type=bool,default=True,help="shuffle true or false")
    parser.add_argument("--train_size",type=float,default=0.8,help="train size")
    parser.add_argument("--seed",type=int,default=0,help="seed")
    parser.add_argument("--varphi_n_steps",type=int,default=10,help="number of steps")
    parser.add_argument("--varphi_n_layers",type=int,default=5,help="number of layers")
    parser.add_argument("--varphi_hidden_nf",type=int,default=64,help="hidden units")
    parser.add_argument("--n_layers",type=int,default=10,help="number of layers")
    parser.add_argument("--hidden_nf",type=int,default=16,help="hidden units")
    parser.add_argument("--split",type=bool,default=True,help="split true or false")
    parser.add_argument("--batch_size",type=int,default=64,help="batch size")
    parser.add_argument("--n_dim",type=int,default=1,help="number of dimensions")
    parser.add_argument("--path",type=str,default="models/interpolation/run-20240728_130602-cxjuyx7v/files/parameters",help="path to CNF model")
    args = parser.parse_args()
    return args
